@echo off
setlocal enabledelayedexpansion

:: Initialize an array to hold COM ports
set "comPorts="
set "index=0"

:: Query the registry for COM ports
for /f "tokens=2*" %%a in ('reg query "HKEY_LOCAL_MACHINE\HARDWARE\DEVICEMAP\SERIALCOMM"') do (
    set "comPorts[!index!]=%%b"
    set /a index+=1
)

:: Check if any COM ports were found
if !index! == 0 (
    echo No COM ports found.
    exit /b
)

:: Display the list of COM ports starting from 1
echo Available COM ports:
set /a loopMax=!index!-1
for /L %%i in (0,1,%loopMax%) do (
    set /a displayIndex=%%i+1
    echo !displayIndex! : !comPorts[%%i]!
)

:: Prompt the user to select a COM port
set /p choice="Select a COM port by number (1 to !index!): "

:: Validate the input
if "%choice%"=="" (
    echo Invalid selection. No input provided.
    exit /b
)

:: Convert to 0-based index for array access
set /a choice-=1

if !choice! lss 0 (
    echo Invalid selection.
    exit /b
)

if !choice! geq !index! (
    echo Invalid selection.
    exit /b
)

:: Save the chosen COM port to a variable
set "SELECTED_PORT=!comPorts[%choice%]!"

:: Display the selected COM port
echo.
echo Selected port: !SELECTED_PORT!
echo.

echo Ready to flash ESP32-S3 on !SELECTED_PORT!
echo.
echo The following files will be flashed:
echo - Bootloader: bootloader.bin at 0x0
echo - Application: APP_2024Av00.43.bin at 0x10000
echo - Partition Table: partition-table.bin at 0x8000
echo - OTA Data: ota_data_initial.bin at 0xe000
echo - SPIFFS: SPIFFS_2024Av00.43.bin at 0x910000
echo.

set /p CONTINUE=Press Enter to continue or Ctrl+C to cancel...

echo.
echo Flashing ESP32-S3...
echo.

esptool.exe -p !SELECTED_PORT! -b 460800 --before default_reset --after hard_reset --chip esp32s3 write_flash --flash_mode dio --flash_freq 80m --flash_size 16MB 0x0 bootloader.bin 0x10000 APP_2024Av00.43.bin 0x8000 partition-table.bin 0xe000 ota_data_initial.bin 0x910000 SPIFFS_2024Av00.43.bin

if %ERRORLEVEL% NEQ 0 (
    echo.
    echo ERROR: Flashing failed with error code %ERRORLEVEL%
    pause
    exit /b %ERRORLEVEL%
) else (
    echo.
    echo Flashing completed successfully!
    pause
)

endlocal

